/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CElement;
import com.myphysicslab.simlab.ConvertMap;
import java.awt.Color;
import java.awt.Graphics;

class CGradient
extends CElement {
    private double[][] matrix;
    private double w;
    private double h;

    public CGradient() {
        super(0.0, 0.0, 1.0, 1.0);
        this.h = this.w = 3.0;
        this.matrix = new double[15][15];
    }

    public void setCenterX(double x) {
        this.m_X1 = x - this.w / 2.0;
        this.m_X2 = this.m_X1 + this.w;
    }

    public void setCenterY(double y) {
        this.m_Y1 = y - this.h / 2.0;
        this.m_Y2 = this.m_Y1 + this.h;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    public double[][] getMatrix() {
        return this.matrix;
    }

    public void draw(Graphics g, ConvertMap map) {
        int R = this.matrix.length;
        if (R == 0) {
            return;
        }
        int C = this.matrix[0].length;
        if (C == 0) {
            return;
        }
        double incX = this.w / (double)R;
        double incY = this.h / (double)C;
        for (int i = 0; i < R; ++i) {
            for (int j = 0; j < C; ++j) {
                int d;
                double x = this.m_X1 + incX * (double)i - incX / 2.0;
                double y = this.m_Y1 + incY * (double)j - incY / 2.0;
                int x1 = map.simToScreenX(x);
                int y1 = map.simToScreenY(y);
                int x2 = map.simToScreenX(x + incX);
                int y2 = map.simToScreenY(y + incY);
                if (x2 < x1) {
                    d = x2;
                    x2 = x1;
                    x1 = d;
                }
                if (y2 < y1) {
                    d = y2;
                    y2 = y1;
                    y1 = d;
                }
                float v = (float)this.matrix[i][j];
                g.setColor(new Color(v, v, v));
                g.fillRect(x1, y1, x2 - x1, y2 - y1);
            }
        }
    }
}

