/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.ConvertMap;
import com.myphysicslab.simlab.DoubleRect;
import java.awt.Rectangle;

public class CoordMap {
    public static final int ALIGN_MIDDLE = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_UPPER = 3;
    public static final int ALIGN_LOWER = 4;
    public static final int INCREASE_UP = -1;
    public static final int INCREASE_DOWN = 1;
    private int y_direction = 1;
    private int origin_x = 0;
    private int origin_y = 0;
    private int screen_left = 0;
    private int screen_top = 0;
    private int screen_width = 0;
    private int screen_height = 0;
    private double pixel_per_unit_x = 100.0;
    private double pixel_per_unit_y = 100.0;
    private boolean fill_screen = false;
    private boolean zoomMode = false;
    private boolean originFixed = false;
    private boolean scaleFixed = false;
    private double zx1;
    private double zx2;
    private double zy1;
    private double zy2;
    private double simMinX = -10.0;
    private double simMaxX = 10.0;
    private double simMinY = -10.0;
    private double simMaxY = 10.0;
    private int align_x = 1;
    private int align_y = 3;
    private ConvertMap convertMap = new ConvertMap(this);

    public CoordMap() {
        this(-1, -10.0, 10.0, -10.0, 10.0, 0, 0);
    }

    public CoordMap(int y_dir, double x1, double x2, double y1, double y2, int align_x, int align_y) {
        this.y_direction = y_dir;
        this.align_x = align_x;
        this.align_y = align_y;
        this.setRange(x1, x2, y1, y2);
    }

    public CoordMap(int y_dir, double x1, double x2, double y1, double y2, int originX, int originY, double scaleX, double scaleY) {
        this.y_direction = y_dir;
        this.originFixed = true;
        this.origin_x = originX;
        this.origin_y = originY;
        this.scaleFixed = true;
        this.pixel_per_unit_x = scaleX;
        this.pixel_per_unit_y = scaleY;
        this.setRange(x1, x2, y1, y2);
    }

    public ConvertMap getConvertMap() {
        return this.convertMap;
    }

    public String toString() {
        String s = "CoordMap with [";
        s = s + (this.scaleFixed ? " scaleFixed, " : "");
        s = s + (this.originFixed ? " originFixed, " : "");
        s = s + (this.fill_screen ? " fill_screen, " : "");
        s = s + ", y_direction=" + (this.y_direction == -1 ? "UP" : "DOWN");
        s = s + ", SCREEN (left=" + this.screen_left;
        s = s + ", top=" + this.screen_top;
        s = s + ", width=" + this.screen_width;
        s = s + ", height=" + this.screen_height + ")";
        s = s + ", SIM (x1=" + this.simMinX + ",x2=" + this.simMaxX + ",y1=" + this.simMinY + ",y2=" + this.simMaxY + ")";
        s = s + ", scale(x=" + this.pixel_per_unit_x + ", y=" + this.pixel_per_unit_y + ")";
        s = s + ", origin(x=" + this.origin_x + ", y=" + this.origin_y + ")";
        s = s + "]";
        return s;
    }

    private void recalc() {
        double sim_width = this.simMaxX - this.simMinX;
        double sim_height = this.simMaxY - this.simMinY;
        if (this.zoomMode) {
            if (!this.scaleFixed) {
                this.pixel_per_unit_x = (double)this.screen_width / (this.zx2 - this.zx1);
                this.pixel_per_unit_y = (double)this.screen_height / (this.zy2 - this.zy1);
            }
            if (!this.originFixed) {
                this.origin_x = this.screen_left - (int)(this.zx1 * this.pixel_per_unit_x + 0.4999);
                this.origin_y = this.y_direction == 1 ? this.screen_top - (int)(this.zy1 * this.pixel_per_unit_y + 0.4999) : this.screen_top + this.screen_height + (int)(this.zy1 * this.pixel_per_unit_y + 0.4999);
            }
        } else if (this.fill_screen) {
            if (!this.scaleFixed) {
                this.pixel_per_unit_x = (double)this.screen_width / sim_width;
                this.pixel_per_unit_y = (double)this.screen_height / sim_height;
            }
            if (!this.originFixed) {
                this.origin_x = this.screen_left - (int)(this.simMinX * this.pixel_per_unit_x + 0.4999);
                this.origin_y = this.y_direction == 1 ? this.screen_top - (int)(this.simMinY * this.pixel_per_unit_y + 0.4999) : this.screen_top + this.screen_height + (int)(this.simMinY * this.pixel_per_unit_y + 0.4999);
            }
        } else {
            int offset_x;
            int offset_y;
            if (sim_width <= 0.0 || sim_height <= 0.0) {
                System.out.println("WARNING: Coordmap cannot recalc, found zero sim width " + sim_width + " or height " + sim_height);
                return;
            }
            if (this.screen_width <= 0 || this.screen_height <= 0) {
                return;
            }
            int ideal_height = (int)((double)this.screen_width * sim_height / sim_width);
            if (this.screen_height < ideal_height) {
                if (!this.scaleFixed) {
                    this.pixel_per_unit_y = this.pixel_per_unit_x = (double)this.screen_height / sim_height;
                }
                offset_y = 0;
                int ideal_width = (int)(sim_width * this.pixel_per_unit_x);
                switch (this.align_x) {
                    case 1: {
                        offset_x = 0;
                        break;
                    }
                    case 2: {
                        offset_x = this.screen_width - ideal_width;
                        break;
                    }
                    case 0: {
                        offset_x = (this.screen_width - ideal_width) / 2;
                        break;
                    }
                    default: {
                        offset_x = 0;
                        break;
                    }
                }
            } else {
                this.pixel_per_unit_y = this.pixel_per_unit_x = (double)this.screen_width / sim_width;
                offset_x = 0;
                ideal_height = (int)(sim_height * this.pixel_per_unit_y);
                switch (this.align_y) {
                    case 3: {
                        offset_y = 0;
                        break;
                    }
                    case 0: {
                        offset_y = (this.screen_height - ideal_height) / 2;
                        break;
                    }
                    case 4: {
                        offset_y = this.screen_height - ideal_height;
                        break;
                    }
                    default: {
                        offset_y = 0;
                    }
                }
            }
            if (!this.originFixed) {
                this.origin_x = this.screen_left + offset_x - (int)(this.simMinX * this.pixel_per_unit_x);
                this.origin_y = this.y_direction == 1 ? this.screen_top + offset_y - (int)(this.simMinY * this.pixel_per_unit_y) : this.screen_top + this.screen_height - offset_y + (int)(this.simMinY * this.pixel_per_unit_y);
            }
        }
    }

    public void setAlignment(int align_x, int align_y) {
        this.align_x = align_x;
        this.align_y = align_y;
        this.originFixed = false;
        this.recalc();
    }

    public void setOrigin(int x, int y) {
        this.origin_x = x;
        this.origin_y = y;
        this.originFixed = true;
    }

    public void setScale(double x, double y) {
        this.pixel_per_unit_x = x;
        this.pixel_per_unit_y = y;
        this.scaleFixed = true;
    }

    public void zoom(double x1, double x2, double y1, double y2) {
        if (y2 <= y1) {
            throw new IllegalArgumentException("CoordMap:zoom() y1=" + y1 + " must be less than y2=" + y2);
        }
        if (x2 <= x1) {
            throw new IllegalArgumentException("CoordMap:zoom() x1=" + x1 + " must be less than x2=" + x2);
        }
        this.zoomMode = true;
        this.scaleFixed = false;
        this.originFixed = false;
        this.zx1 = x1;
        this.zx2 = x2;
        this.zy1 = y1;
        this.zy2 = y2;
        this.recalc();
    }

    public void setZoom(boolean state) {
        this.zoomMode = state;
        this.recalc();
    }

    public void setFillScreen(boolean f) {
        this.fill_screen = f;
        this.scaleFixed = false;
        this.recalc();
    }

    public boolean expand() {
        if (this.screen_width > 0 && this.screen_height > 0) {
            this.simMinX = this.screenToSimX(this.screen_left);
            this.simMaxX = this.screenToSimX(this.screen_left + this.screen_width);
            this.simMinY = this.screenToSimY(this.screen_top);
            this.simMaxY = this.screenToSimY(this.screen_top + this.screen_height);
            if (this.simMinY > this.simMaxY) {
                double d = this.simMinY;
                this.simMinY = this.simMaxY;
                this.simMaxY = d;
            }
            this.scaleFixed = false;
            this.recalc();
            return true;
        }
        return false;
    }

    public void setRange(double xlo, double xhi, double ylo, double yhi) {
        this.simMinX = xlo;
        this.simMaxX = xhi;
        this.simMinY = ylo;
        this.simMaxY = yhi;
        this.recalc();
    }

    public void setScreen(int left, int top, int width, int height) {
        if (width > 0 && height > 0) {
            this.screen_top = top;
            this.screen_left = left;
            this.screen_width = width;
            this.screen_height = height;
            this.recalc();
        }
    }

    public int simToScreenScaleX(double x) {
        return (int)(x * this.pixel_per_unit_x + 0.5);
    }

    public int simToScreenScaleY(double y) {
        return (int)(y * this.pixel_per_unit_y + 0.5);
    }

    public int simToScreenX(double x) {
        return this.origin_x + (int)(x * this.pixel_per_unit_x + 0.5);
    }

    public int simToScreenY(double y) {
        return this.origin_y + this.y_direction * (int)(y * this.pixel_per_unit_y + 0.5);
    }

    public double screenToSimX(int scr_x) {
        return (double)(scr_x - this.origin_x) / this.pixel_per_unit_x;
    }

    public double screenToSimY(int scr_y) {
        return (double)this.y_direction * (double)(scr_y - this.origin_y) / this.pixel_per_unit_y;
    }

    public DoubleRect getSimBounds() {
        return new DoubleRect(this.simMinX, this.simMinY, this.simMaxX, this.simMaxY);
    }

    public Rectangle getScreenRect() {
        double top = this.y_direction == -1 ? this.simMaxY : this.simMinY;
        return new Rectangle(this.simToScreenX(this.simMinX), this.simToScreenY(top), this.simToScreenScaleX(this.simMaxX - this.simMinX), this.simToScreenScaleY(this.simMaxY - this.simMinY));
    }

    public double getMinX() {
        return this.simMinX;
    }

    public double getMaxX() {
        return this.simMaxX;
    }

    public double getMinY() {
        return this.simMinY;
    }

    public double getMaxY() {
        return this.simMaxY;
    }

    public boolean intersectRect(Rectangle r) {
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int sx1 = this.screen_left;
        int sy1 = this.screen_top;
        int sx2 = this.screen_left + this.screen_width;
        int sy2 = this.screen_top + this.screen_height;
        if (sx1 >= x2) {
            return false;
        }
        if (x1 >= sx2) {
            return false;
        }
        if (sy1 >= y2) {
            return false;
        }
        return y1 < sy2;
    }
}

