/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.MoveableDoublePendulum;
import com.myphysicslab.simlab.SimFrame;
import com.myphysicslab.simlab.SimThread;
import com.myphysicslab.simlab.Simulation;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JApplet;

public class LabTest
extends JApplet {
    private SimThread timer = null;
    private Simulation sim = null;
    private boolean firstUpdate = true;

    public static void main(String[] args) {
        LabTest applet = new LabTest();
        SimFrame frame = new SimFrame(applet);
        frame.setContentPane(applet.getContentPane());
        frame.setVisible(true);
        ((Applet)applet).init();
    }

    public void init() {
        System.out.println("starting MyPhysicsLab Test");
        this.getContentPane().setBackground(Color.white);
        this.sim = new MoveableDoublePendulum(this.getContentPane());
        if (this.sim == null) {
            throw new IllegalStateException("unable to create simulation " + this.sim);
        }
        System.out.println("Simulation created " + this.sim);
        CoordMap map = this.sim.getCoordMap();
        map.setOrigin(300, 150);
        map.setScale(100.0, 100.0);
        this.sim.setParameter("gravity", 9.8);
        this.sim.setVariable(0, 0.0);
        this.sim.setVariable(1, 1.5);
        this.getContentPane().setLayout(new BorderLayout());
        Component cnvs = this.getContentPane().getComponent(0);
        this.getContentPane().add(cnvs, "Center");
        System.out.println("in init(), window size: " + this.getContentPane().getSize().width + " " + this.getContentPane().getSize().height);
        this.getContentPane().invalidate();
        this.getContentPane().validate();
        this.getContentPane().repaint();
        this.start();
    }

    public void start() {
        if (this.timer == null && this.sim != null) {
            this.timer = new SimThread((Runnable)this.sim, 10L);
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer != null) {
            this.timer.interrupt();
            this.timer = null;
        }
    }
}

