/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CRect;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.CollidingSim;
import com.myphysicslab.simlab.CoordMap;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.DoubleRect;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.ObjectListener;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;

public class Molecule1
extends CollidingSim
implements ActionListener,
ObjectListener {
    private CSpring m_Spring;
    private CMass m_Mass1;
    private CMass m_Mass2;
    private CRect m_Walls;
    private double m_Elasticity = 0.8;
    private double m_Damping = 0.0;
    private double m_Gravity = 6.0;
    private static final int TOP_WALL = 1;
    private static final int BOTTOM_WALL = 2;
    private static final int LEFT_WALL = 3;
    private static final int RIGHT_WALL = 4;
    private double m_Left;
    private double m_Right;
    private double m_Top;
    private double m_Bottom;
    private JButton button_stop;
    private Vector collisions = new Vector(10);
    private static final String MASS1 = "blue mass";
    private static final String MASS2 = "red mass";
    private static final String ELASTICITY = "elasticity";
    private static final String GRAVITY = "gravity";
    private static final String DAMPING = "damping";
    private static final String LENGTH = "spring rest length";
    private static final String STIFFNESS = "spring stiffness";
    private String[] params = new String[]{"blue mass", "red mass", "elasticity", "gravity", "damping", "spring stiffness", "spring rest length"};

    public Molecule1(Container container) {
        super(container, 8);
        this.var_names = new String[]{"x1 position", "y1 position", "x2 position", "y2 position", "x1 velocity", "y1 velocity", "x2 velocity", "y2 velocity"};
        this.setCoordMap(new CoordMap(-1, -6.0, 6.0, -6.0, 6.0, 0, 0));
        double xx = 0.0;
        double yy = -2.0;
        double w = 0.5;
        DoubleRect box = this.cvs.getSimBounds();
        this.m_Left = box.getXMin() + w / 2.0;
        this.m_Right = box.getXMax() - w / 2.0;
        this.m_Bottom = box.getYMin() + w / 2.0;
        this.m_Top = box.getYMax() - w / 2.0;
        this.m_Walls = new CRect(box);
        this.cvs.addElement(this.m_Walls);
        this.cvs.setObjectListener(this);
        this.m_Mass1 = new CMass(0.0, 0.0, w, w, 5);
        this.m_Mass1.m_Mass = 0.5;
        this.m_Mass1.m_Color = Color.blue;
        this.cvs.addElement(this.m_Mass1);
        this.m_Mass2 = new CMass(1.0, -1.0, w, w, 5);
        this.m_Mass2.m_Mass = 0.5;
        this.cvs.addElement(this.m_Mass2);
        this.m_Spring = new CSpring(0.0, 0.0, 1.0, 0.3);
        this.m_Spring.setX2(this.m_Mass2.getCenterX());
        this.m_Spring.setY2(this.m_Mass2.getCenterY());
        this.m_Spring.m_SpringConst = 6.0;
        this.cvs.addElement(this.m_Spring);
        this.vars[0] = this.m_Mass1.getCenterX();
        this.vars[1] = this.m_Mass1.getCenterY();
        this.vars[2] = this.m_Mass2.getCenterX();
        this.vars[3] = this.m_Mass2.getCenterY();
        this.vars[7] = 0.0;
        this.vars[6] = 0.0;
        this.vars[5] = 0.0;
        this.vars[4] = 0.0;
        this.vars[4] = 2.0;
        this.modifyObjects();
    }

    public void setupControls() {
        super.setupControls();
        this.button_stop = new JButton("reset");
        this.addControl(this.button_stop);
        this.button_stop.addActionListener(this);
        for (int i = 0; i < this.params.length; ++i) {
            this.addObserverControl(new DoubleField(this, this.params[i], 2));
        }
        this.showControls(true);
    }

    public void setupGraph() {
        super.setupGraph();
        if (this.graph != null) {
            this.graph.setVars(0, 1);
        }
        this.showGraph(false);
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(MASS1)) {
            this.m_Mass1.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            this.m_Mass2.m_Mass = value;
            return true;
        }
        if (name.equalsIgnoreCase(ELASTICITY)) {
            this.m_Elasticity = value;
            return true;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            this.m_Gravity = value;
            return true;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            this.m_Damping = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            this.m_Spring.m_SpringConst = value;
            return true;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            this.m_Spring.m_RestLength = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(MASS1)) {
            return this.m_Mass1.m_Mass;
        }
        if (name.equalsIgnoreCase(MASS2)) {
            return this.m_Mass2.m_Mass;
        }
        if (name.equalsIgnoreCase(ELASTICITY)) {
            return this.m_Elasticity;
        }
        if (name.equalsIgnoreCase(GRAVITY)) {
            return this.m_Gravity;
        }
        if (name.equalsIgnoreCase(DAMPING)) {
            return this.m_Damping;
        }
        if (name.equalsIgnoreCase(STIFFNESS)) {
            return this.m_Spring.m_SpringConst;
        }
        if (name.equalsIgnoreCase(LENGTH)) {
            return this.m_Spring.m_RestLength;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        return this.params;
    }

    public void objectChanged(Object o) {
        if (o == this.cvs) {
            DoubleRect box = this.cvs.getSimBounds();
            this.m_Walls.setBounds(box);
            double w = this.m_Mass1.m_Width;
            this.m_Left = box.getXMin() + w / 2.0;
            this.m_Right = box.getXMax() - w / 2.0;
            this.m_Bottom = box.getYMin() + w / 2.0;
            this.m_Top = box.getYMax() - w / 2.0;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.button_stop) {
            this.vars[0] = -1.0;
            this.vars[1] = -1.0;
            this.vars[2] = 1.0;
            this.vars[3] = 1.0;
            this.vars[7] = 0.0;
            this.vars[6] = 0.0;
            this.vars[5] = 0.0;
            this.vars[4] = 0.0;
        }
    }

    public void modifyObjects() {
        double w = this.m_Mass1.m_Width / 2.0;
        this.m_Mass1.setX1(this.vars[0] - w);
        this.m_Mass1.setY1(this.vars[1] - w);
        this.m_Mass2.setX1(this.vars[2] - w);
        this.m_Mass2.setY1(this.vars[3] - w);
        this.m_Spring.setX1(this.vars[0]);
        this.m_Spring.setY1(this.vars[1]);
        this.m_Spring.setX2(this.vars[2]);
        this.m_Spring.setY2(this.vars[3]);
    }

    public void startDrag(Dragable e) {
        if (e == this.m_Mass1) {
            this.calc[5] = false;
            this.calc[4] = false;
            this.calc[1] = false;
            this.calc[0] = false;
        } else if (e == this.m_Mass2) {
            this.calc[7] = false;
            this.calc[6] = false;
            this.calc[3] = false;
            this.calc[2] = false;
        }
    }

    public void constrainedSet(Dragable e, double x, double y) {
        double w = this.m_Mass1.m_Width / 2.0;
        x += w;
        y += w;
        if (x < this.m_Left) {
            x = this.m_Left + 1.0E-4;
        }
        if (x > this.m_Right) {
            x = this.m_Right - 1.0E-4;
        }
        if (y < this.m_Bottom) {
            y = this.m_Bottom + 1.0E-4;
        }
        if (y > this.m_Top) {
            y = this.m_Top - 1.0E-4;
        }
        if (e == this.m_Mass1) {
            this.vars[0] = x;
            this.vars[1] = y;
            this.vars[5] = 0.0;
            this.vars[4] = 0.0;
        } else if (e == this.m_Mass2) {
            this.vars[2] = x;
            this.vars[3] = y;
            this.vars[7] = 0.0;
            this.vars[6] = 0.0;
        }
    }

    private void addCollision(int obj1, int obj2) {
        this.collisions.addElement(new int[]{obj1, obj2});
    }

    public Vector findAllCollisions() {
        this.collisions.removeAllElements();
        for (int j = 0; j < 2; ++j) {
            if (this.vars[2 * j] < this.m_Left) {
                this.addCollision(3, j);
            }
            if (this.vars[2 * j] > this.m_Right) {
                this.addCollision(4, j);
            }
            if (this.vars[1 + 2 * j] < this.m_Bottom) {
                this.addCollision(2, j);
            }
            if (!(this.vars[1 + 2 * j] > this.m_Top)) continue;
            this.addCollision(1, j);
        }
        return this.collisions.size() > 0 ? this.collisions : null;
    }

    public void handleCollisions(Vector collisions) {
        block4: for (int i = 0; i < collisions.size(); ++i) {
            int[] objs = (int[])collisions.elementAt(i);
            int mi = 2 * objs[1];
            switch (objs[0]) {
                case 3: 
                case 4: {
                    this.vars[4 + mi] = -this.m_Elasticity * this.vars[4 + mi];
                    continue block4;
                }
                case 1: 
                case 2: {
                    this.vars[5 + mi] = -this.m_Elasticity * this.vars[5 + mi];
                }
            }
        }
    }

    public void evaluate(double[] x, double[] change) {
        change[0] = x[4];
        change[1] = x[5];
        change[2] = x[6];
        change[3] = x[7];
        double xx = x[2] - x[0];
        double yy = x[3] - x[1];
        double len = Math.sqrt(xx * xx + yy * yy);
        double m1 = this.m_Mass1.m_Mass;
        double m2 = this.m_Mass2.m_Mass;
        double DIST_TOL = 0.02;
        double timeStep = 0.03;
        double r = this.m_Spring.m_SpringConst / m1 * (len - this.m_Spring.m_RestLength) * xx / len;
        if (r < 0.0 && Math.abs(x[0] - this.m_Left) < DIST_TOL && Math.abs(x[4]) < -r * timeStep / (2.0 * m1)) {
            x[4] = 0.0;
            r = 0.0;
            x[0] = this.m_Left;
        } else if (r > 0.0 && Math.abs(x[0] - this.m_Right) < DIST_TOL && Math.abs(x[4]) < r * timeStep / (2.0 * m1)) {
            x[4] = 0.0;
            r = 0.0;
            x[0] = this.m_Right;
        } else if (this.m_Damping != 0.0) {
            r -= this.m_Damping / m1 * x[4];
        }
        change[4] = r;
        r = -this.m_Gravity + this.m_Spring.m_SpringConst / m1 * (len - this.m_Spring.m_RestLength) * yy / len;
        if (r < 0.0 && Math.abs(x[1] - this.m_Bottom) < DIST_TOL && Math.abs(x[5]) < -r * timeStep / (2.0 * m1)) {
            x[5] = 0.0;
            r = 0.0;
            x[1] = this.m_Bottom;
        } else if (r > 0.0 && Math.abs(x[1] - this.m_Top) < DIST_TOL && Math.abs(x[5]) < r * timeStep / (2.0 * m1)) {
            x[5] = 0.0;
            r = 0.0;
            x[1] = this.m_Top;
        } else if (this.m_Damping != 0.0) {
            r -= this.m_Damping / m1 * x[5];
        }
        change[5] = r;
        r = -(this.m_Spring.m_SpringConst / m2) * (len - this.m_Spring.m_RestLength) * xx / len;
        if (r < 0.0 && Math.abs(x[2] - this.m_Left) < DIST_TOL && Math.abs(x[6]) < -r * timeStep / (2.0 * m2)) {
            x[6] = 0.0;
            r = 0.0;
            x[2] = this.m_Left;
        } else if (r > 0.0 && Math.abs(x[2] - this.m_Right) < DIST_TOL && Math.abs(x[6]) < r * timeStep / (2.0 * m2)) {
            x[6] = 0.0;
            r = 0.0;
            x[2] = this.m_Right;
        } else if (this.m_Damping != 0.0) {
            r -= this.m_Damping / m2 * x[6];
        }
        change[6] = r;
        r = -this.m_Gravity - this.m_Spring.m_SpringConst / m2 * (len - this.m_Spring.m_RestLength) * yy / len;
        if (r < 0.0 && Math.abs(x[3] - this.m_Bottom) < DIST_TOL && Math.abs(x[7]) < -r * timeStep / (2.0 * m2)) {
            x[7] = 0.0;
            r = 0.0;
            x[3] = this.m_Bottom;
        } else if (r > 0.0 && Math.abs(x[3] - this.m_Top) < DIST_TOL && Math.abs(x[7]) < r * timeStep / (2.0 * m2)) {
            x[7] = 0.0;
            r = 0.0;
            x[3] = this.m_Top;
        } else if (this.m_Damping != 0.0) {
            r -= this.m_Damping / m2 * x[7];
        }
        change[7] = r;
    }
}

