/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.MyLabel;
import com.myphysicslab.simlab.MyScrollbar;
import com.myphysicslab.simlab.Observer;
import com.myphysicslab.simlab.Subject;
import java.awt.FlowLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.text.NumberFormat;
import javax.swing.JComponent;

class MySlider
extends JComponent
implements AdjustmentListener,
Observer {
    private double min;
    private double delta;
    private double value;
    private MyScrollbar scroll;
    private MyLabel nameLabel;
    private MyLabel myNumber;
    private NumberFormat nf;
    private Subject subj;
    private String name;

    public MySlider(Subject subj, String name, double min, double max, int increments, int digits) {
        this.subj = subj;
        this.name = name;
        this.min = min;
        this.value = subj.getParameter(name);
        this.delta = (max - min) / (double)increments;
        this.nameLabel = new MyLabel(name, 0);
        this.add(this.nameLabel);
        this.scroll = new MyScrollbar(75, 15, 0, (int)(0.5 + (this.value - min) / this.delta), 10, 0, increments + 10);
        this.add(this.scroll);
        this.scroll.addAdjustmentListener(this);
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(digits);
        this.nf.setMinimumFractionDigits(digits);
        this.myNumber = new MyLabel(this.nf.format(this.value), 2, "88.88");
        this.add(this.myNumber);
        this.setLayout(new FlowLayout(1, 1, 1));
    }

    public String toString() {
        return "MySlider \"" + this.name + "\" value=" + this.nf.format(this.value);
    }

    public void update(Subject subj, String param, double value) {
        if (param.equalsIgnoreCase(this.name) && value != this.value) {
            this.value = value;
            this.myNumber.setText(this.nf.format(value));
            this.scroll.setValue((int)(0.5 + (value - this.min) / this.delta));
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getAdjustable() == this.scroll) {
            this.value = this.min + (double)this.scroll.getValue() * this.delta;
            this.myNumber.setText(this.nf.format(this.value));
            if (this.subj != null) {
                this.subj.setParameter(this.name, this.value);
            }
        }
    }
}

