/*
 * Decompiled with CFR 0.152.
 */
package com.myphysicslab.simlab;

import com.myphysicslab.simlab.CMass;
import com.myphysicslab.simlab.CSpring;
import com.myphysicslab.simlab.DoubleField;
import com.myphysicslab.simlab.DoubleRect;
import com.myphysicslab.simlab.Dragable;
import com.myphysicslab.simlab.Roller1;
import java.awt.Container;

public class Roller2
extends Roller1 {
    protected CMass m_TopMass;
    protected CSpring m_Spring;
    protected static final String STIFF = "spring stiffness";
    protected static final String LENGTH = "spring rest length";

    public Roller2(Container app, int the_path) {
        super(app, the_path);
    }

    public void setupControls() {
        super.setupControls();
        this.addObserverControl(new DoubleField(this, LENGTH, 2));
        this.addObserverControl(new DoubleField(this, STIFF, 2));
    }

    protected void createElements() {
        super.createElements();
        this.m_Spring = new CSpring(1.0, 1.0, 1.0, 0.5);
        this.m_Spring.m_SpringConst = 5.0;
        this.cvs.addElement(this.m_Spring);
        this.m_TopMass = new CMass(0.0, 0.0, 0.5, 0.5, 1);
        this.cvs.addElement(this.m_TopMass);
    }

    protected boolean trySetParameter(String name, double value) {
        if (name.equalsIgnoreCase(LENGTH)) {
            this.m_Spring.m_RestLength = value;
            return true;
        }
        if (name.equalsIgnoreCase(STIFF)) {
            this.m_Spring.m_SpringConst = value;
            return true;
        }
        return super.trySetParameter(name, value);
    }

    public double getParameter(String name) {
        if (name.equalsIgnoreCase(LENGTH)) {
            return this.m_Spring.m_RestLength;
        }
        if (name.equalsIgnoreCase(STIFF)) {
            return this.m_Spring.m_SpringConst;
        }
        return super.getParameter(name);
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"mass", "damping", "gravity", "path", "show energy", STIFF, LENGTH};
        return params;
    }

    protected void set_path(int the_path) {
        double yy;
        double xx;
        super.set_path(the_path);
        if (this.m_Path.closed) {
            xx = this.m_Path.left + 0.05 * (this.m_Path.right - this.m_Path.left);
            yy = this.m_Path.bottom + 0.1 * (this.m_Path.top - this.m_Path.bottom);
        } else {
            xx = this.m_Path.left + 0.3 * (this.m_Path.right - this.m_Path.left);
            yy = this.m_Path.bottom + 0.5 * (this.m_Path.top - this.m_Path.bottom);
        }
        this.m_Spring.setX1(xx);
        this.m_Spring.setY1(yy);
        this.m_TopMass.setCenterX(xx);
        this.m_TopMass.setCenterY(yy);
    }

    public void modifyObjects() {
        this.vars[0] = this.m_Path.modp(this.vars[0]);
        this.m_Point.p = this.vars[0];
        this.m_Path.map_p_to_slope(this.m_Point);
        this.m_Mass1.setCenterX(this.m_Point.x);
        this.m_Mass1.setCenterY(this.m_Point.y);
        this.m_Spring.setX2(this.m_Point.x);
        this.m_Spring.setY2(this.m_Point.y);
        this.m_Text.setNumber(this.getEnergy());
    }

    protected double getEnergy() {
        double e = super.getEnergy();
        return e += this.m_Spring.getEnergy();
    }

    public void constrainedSet(Dragable e, double x, double y) {
        if (e == this.m_TopMass) {
            double w = this.m_TopMass.m_Width / 2.0;
            x += w;
            y += w;
            DoubleRect r = this.cvs.getSimBounds();
            double L = r.getXMin() + w;
            double R = r.getXMax() - w;
            double B = r.getYMin() + w;
            double T = r.getYMax() - w;
            if (x < L) {
                x = L + 1.0E-4;
            }
            if (x > R) {
                x = R - 1.0E-4;
            }
            if (y < B) {
                y = B + 1.0E-4;
            }
            if (y > T) {
                y = T - 1.0E-4;
            }
            this.m_TopMass.setCenterX(x);
            this.m_TopMass.setCenterY(y);
            this.m_Spring.setX1(x);
            this.m_Spring.setY1(y);
        } else if (e == this.m_Mass1) {
            double w = this.m_Mass1.m_Width / 2.0;
            this.vars[0] = this.m_Path.map_x_y_to_p(x + w, y + w);
            this.vars[1] = 0.0;
            this.modifyObjects();
        }
    }

    public void evaluate(double[] x, double[] change) {
        change[0] = x[1];
        this.m_Point.p = x[0];
        this.m_Path.map_p_to_slope(this.m_Point);
        double k = this.m_Point.slope;
        double sinTheta = Double.isInfinite(k) ? 1.0 : k / Math.sqrt(1.0 + k * k);
        change[1] = -this.gravity * (double)this.m_Point.direction * sinTheta;
        change[1] = change[1] - this.m_Mass1.m_Damping * x[1] / this.m_Mass1.m_Mass;
        double sx = this.m_Spring.m_X1 - this.m_Point.x;
        double sy = this.m_Spring.m_Y1 - this.m_Point.y;
        double slen = Math.sqrt(sx * sx + sy * sy);
        double cosTheta = Double.isInfinite(k) ? (double)this.m_Point.direction * sy / slen : (double)this.m_Point.direction * (sx + k * sy) / (slen * Math.sqrt(1.0 + k * k));
        if (cosTheta > 1.0 || cosTheta < -1.0) {
            System.out.println("cosTheta out of range in diffeq1");
        }
        double stretch = slen - this.m_Spring.m_RestLength;
        change[1] = change[1] + this.m_Spring.m_SpringConst * cosTheta * stretch / this.m_Mass1.m_Mass;
    }
}

